#include "StrafeCamera.h"

StrafeCamera::StrafeCamera(Vector3 origin, Vector3 pitchYawRoll, StrafeAxis axis, float min, float max) : Camera(1.0f, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_OriginPosition = origin;
	_MouseRotationSpeed = 0.0f;
	_StrafeAxis = axis;
	_MinimumAxisValue = min;
	_MaximumAxisValue = max;
	SetBoundsFromVals();
	Reset();
}

StrafeCamera::StrafeCamera(Vector3 origin, Vector3 pitchYawRoll, float speed, StrafeAxis axis, float min, float max) : Camera(speed, origin, pitchYawRoll)
{
	//Set values passed in, pass some to base constructor
	_OriginPosition = origin;
	_MouseRotationSpeed = 0.0f;
	_StrafeAxis = axis;
	_MinimumAxisValue = min;
	_MaximumAxisValue = max;
	SetBoundsFromVals();
	Reset();
}

StrafeCamera::~StrafeCamera()
{

}

void StrafeCamera::Animate(float dt)
{

}

void StrafeCamera::SetBoundsFromVals()
{
	switch (_StrafeAxis)
	{
		case StrafeAxis::X:	//Update X component of bounds
			_MinimumBounds = Vector3(_MinimumAxisValue, _OriginPosition.y, _OriginPosition.z);
			_MaximumBounds = Vector3(_MaximumAxisValue, _OriginPosition.y, _OriginPosition.z);
			break;

		case StrafeAxis::Y:	//Update Y component of bounds
			_MinimumBounds = Vector3(_OriginPosition.x, _MinimumAxisValue, _OriginPosition.z);
			_MaximumBounds = Vector3(_OriginPosition.x, _MaximumAxisValue, _OriginPosition.z);
			break;

		case StrafeAxis::Z:	//Update Z componnt of bounds
			_MinimumBounds = Vector3(_OriginPosition.x, _OriginPosition.y, _MinimumAxisValue);
			_MaximumBounds = Vector3(_OriginPosition.x, _OriginPosition.y, _MaximumAxisValue);
			break;
	}
}

void StrafeCamera::MoveForward(float dt)
{
	if (_StrafeAxis == StrafeAxis::X)
	{
		if (IsFacing(Direction::East) || IsFacing(Direction::West))
		{
			_PositionVector.x += _ForwardVector.x * _Speed * dt;
			_PositionVector.y += _ForwardVector.y * _Speed * dt;
			_PositionVector.z += _ForwardVector.z * _Speed * dt;
			Update();
		}
	}
	
	if (_StrafeAxis == StrafeAxis::Z)
	{
		if (IsFacing(Direction::North) || IsFacing(Direction::South))
		{
			_PositionVector.x += _ForwardVector.x * _Speed * dt;
			_PositionVector.y += _ForwardVector.y * _Speed * dt;
			_PositionVector.z += _ForwardVector.z * _Speed * dt;
			Update();
		}
	}

}

void StrafeCamera::MoveRight(float dt)
{
	if (_StrafeAxis == StrafeAxis::X)
	{
		if (IsFacing(Direction::North) || IsFacing(Direction::South))
		{
			_PositionVector.x += _RightVector.x * _Speed * dt;
			_PositionVector.y += _RightVector.y * _Speed * dt;
			_PositionVector.z += _RightVector.z * _Speed * dt;
			Update();
		}
	}

	if (_StrafeAxis == StrafeAxis::Z)
	{
		if (IsFacing(Direction::East) || IsFacing(Direction::West))
		{
			_PositionVector.x += _RightVector.x * _Speed * dt;
			_PositionVector.y += _RightVector.y * _Speed * dt;
			_PositionVector.z += _RightVector.z * _Speed * dt;
			Update();
		}
	}
}

void StrafeCamera::MoveUp(float dt)
{
	_PositionVector.y += _Speed * dt;
	Update();
}

void StrafeCamera::RotateX(float dt)
{

}

void StrafeCamera::RotateY(float dt)
{

}

void StrafeCamera::RotateZ(float dt)
{

}

void StrafeCamera::RotateFromMouse(float xOffset, float yOffset, float dt)
{

}
